LoadMapData = function(scene)

	-- tileData table should (probably?) be cleared and re-initialized
	-- each time we load a map.  Otherwise, it would potentially be larger than necessary.
	SRT.TileData = {
		TileSize = nil,
		CollisionTiles = {},
		EventTiles = {},
		Width = { Pixels = nil, Tiles = nil },
		Height = { Pixels = nil, Tiles = nil}
	}

	-- grab the entire tile-data file for the active scene
	-- these files were autogenerated by Tiled (http://www.mapeditor.org/)
	local tiledata = LoadActor( THEME:GetPathB("Overworld", "overlay/Scenes/" .. scene .. "/tile-data.lua"))

	-- NOTE: the entire system is currently hardcoded to only work with
	-- 		square tiles; it assumes that tile width == tile height

	-- store map tile width and height
	SRT.TileData.Width.Tiles = tiledata.width
	SRT.TileData.Height.Tiles= tiledata.height

	-- get the width of a tile; all values below depend on it
	SRT.TileData.TileSize = tiledata.tilewidth
	-- store map pixel width and height
	SRT.TileData.Width.Pixels	= tiledata.width * tiledata.tilewidth
	SRT.TileData.Height.Pixels	= tiledata.height * tiledata.tilewidth
	-- store screen tile width and height
	SRT.Screen.Height.Tiles = _screen.h/tiledata.tilewidth
	SRT.Screen.Width.Tiles	= _screen.w/tiledata.tilewidth

	-- initialize the CollisionTiles table to be the necessary size, and filled with 0s
	-- for i=1 loops are supposedly faster than ipairs() so use where possible/sensible
	for i=1, (SRT.TileData.Width.Tiles * SRT.TileData.Height.Tiles) do
		SRT.TileData.CollisionTiles[i] = 0
	end

	-- we're only interested in the layer data for the sake of handling collisions
	-- so, loop through each layer that was exported
	for key,layer in ipairs(tiledata.layers) do

		-- but only bother with layers that have been named "Collision" by Caitlin
		if layer.name == "Collision" then

			-- there could be multiple such layers, which we want to collapse into one for
			-- the sake of speedy collision checking later
			for i=1, #layer.data do

				-- the tile ID doesn't matter; if it isn't 0, we collide with it
				if layer.data[i] ~= 0 then

					-- save 1s where collisions will occur
					SRT.TileData.CollisionTiles[i] = 1
				end
			end

		-- There will (should) be only be a single "Event" layer per map.
		elseif layer.name == "Event" then
			SRT.TileData.EventTiles = layer.data
		end
	end

	-- SRT.BGM:queuecommand("Set")
end


-- returns a table of two values, right and down, both in tile units
FindCenterOfMap = function()
	-- calculate which tile currently represents map center in terms of tiles right and tiles down from top-left (1,1)
	local r, d = SRT.Player.pos.r, SRT.Player.pos.d
	local MapCenter = {right = r, down = d}

	-- half screen width in tile units
	local half_screen_width_in_tiles  = SRT.Screen.Width.Tiles/2
	-- half screen height in tile units
	local half_screen_height_in_tiles = SRT.Screen.Height.Tiles/2

	-- if players are near the edge of a map, using the MapCenter as calculated above
	-- will result in the map scrolling "too far" and the player seeing beyond the edge of the map
	-- clamp the MapCenter values here to prevent this from occuring

	-- left edge of map
	if (MapCenter.right < half_screen_width_in_tiles) then MapCenter.right = half_screen_width_in_tiles end
	-- right edge of map
	if (MapCenter.right > SRT.TileData.Width.Tiles - half_screen_width_in_tiles) then MapCenter.right = SRT.TileData.Width.Tiles - half_screen_width_in_tiles end
	-- top edge of map
	if (MapCenter.down < half_screen_height_in_tiles) then MapCenter.down = half_screen_height_in_tiles end
	-- bottom edge of map
	if (MapCenter.down > SRT.TileData.Height.Tiles - half_screen_height_in_tiles) then MapCenter.down = SRT.TileData.Height.Tiles - half_screen_height_in_tiles end

	return MapCenter
end


TransitionToBattle = function(i)
	SRT.MapFade:queuecommand("FadeOut")
	SRT.Dialog.Index = 1

	local upsrt_songs = SONGMAN:GetSongsInGroup("UPSRT")
	local song = upsrt_songs[i]
	local chart = song:GetOneSteps( "StepsType_Dance_Single", "Difficulty_Challenge" )

	GAMESTATE:SetCurrentSong( song )
	GAMESTATE:SetCurrentSteps( GAMESTATE:GetMasterPlayerNumber(), chart )
	MESSAGEMAN:Broadcast("ScreenshotCurrentScreen")

	local topscreen = SCREENMAN:GetTopScreen()
	topscreen:SetNextScreenName("EnteringBattle")
	topscreen:GetChild("Overlay"):queuecommand("TransitionScreen")
end


StartDialog = function( c, speaker )
	if not c then c = "#666666" end

	SRT.InputIsLocked = true
	SRT.DialogIsActive = true
	SRT.Dialog.Speaker = speaker

	SRT.Dialog.Box:playcommand("UpdateColor", {Color=color(c)})
	SRT.Dialog.Box:queuecommand("Show"):queuecommand("ClearText"):queuecommand("UpdateText")
end


IsEndGame = function()
	if SRT.Defeated.MadMatt and SRT.Defeated.Archi and SRT.Defeated.LittleMatt then
		return true
	end
	return false
end